# Docs
- purpose/motivation
  - logic only repo offering use-case tailored logic to collecting data
    - no infra code allowed
  - all lib code should be compiled via Jenkins in relevant assets
    - e.g. python logic to python modules etc.
  - multi-language friendly as long as above are respected
  - who might be the client code?
    - code which packages the resulting module(s) in a debian package
    - code which runs the logic in an ephemeral container
    - an aws lambda job calling the logic we define here

# License
- All rights reserved by Raul-Octavian Rus.

# TODO
- solutions for efficient api rate limits handling
  - all above job schedulers are python native
  - in python, packages such as tenacity, ratelimit, requests
- proposed design for data organization
  - by app/date is **better** than by date/app
  - we choose by app/date
- keep historical timeseries of queries used against to get the specific instance of data
  - consider logging queries somewhere either via json next to the data or to mark them in centralized logging system
- document timeseries of all fundamental data changes as they are discovered
  - this is to allow the correct processing of data after meaning changes

# Progress
- eodhd.com
  - current subscription as of 2024.10.03 - Fundamentals Data API (only)
  - below are all queries to be designed to download on demand
    - currently unsure how to get all possible codes that can be queries under each category -> need to email support to ask for exhaustive list
    - subsequent email to support should be to ask about the Extended Fundamentals API -> not listed in pricing so need to ask (might be free?)
      - enables bulk requests for there queries, which otherwise are only available instrument by instrument and under API calls limitations
  - available exchanges and symbols list available at
    - https://eodhd.com/financial-apis/exchanges-api-list-of-tickers-and-trading-hours#Get_List_of_Tickers_Exchange_Symbols
```bash
# queries
# - for stocks
curl -L https://eodhd.com/api/fundamentals/AAPL.US?api_token=${EODHD_API_TOKEN}&fmt=json
# - for ETFs
curl -L https://eodhd.com/api/fundamentals/SWPPX.US?api_token=${EODHD_API_TOKEN}&fmt=json
# - for indices
curl -L https://eodhd.com/api/fundamentals/GSPC.INDX?api_token=${EODHD_API_TOKEN}&fmt=json
# - historical - not sure if applies for all instrument types or just index???
# - docs seem to softly imply that S&P only supported - need to test
curl -L https://eodhd.com/api/fundamentals/GSPC.INDX?historical=1&from=2020-01-01&to=2023-01-01&api_token=${EODHD_API_TOKEN}&fmt=json
```
