#!/bin/bash

# Logrotate cron job for eodhd_download logs
# --- setup logrotate config
sudo mkdir -p /etc/logrotate.d
sudo chown root:root /etc/logrotate.d
sudo chmod 755 /etc/logrotate.d
sudo touch /etc/logrotate.d/eodhd_download
sudo chown $USER:$GROUP /etc/logrotate.d/eodhd_download
sudo chmod 644 /etc/logrotate.d/eodhd_download
cat << EOF >> /etc/logrotate.d/eodhd_download
/var/log/eodhd_download.log {
    weekly
    rotate 4
    compress
    delaycompress
    missingok
    notifempty
    copytruncate
    create 0644 ${USER} ${GROUP}
}
EOF
# --- add cron job for eodhd_download log rotation
# - this goes under active user
# - it is best to avoid jobs under root as much as possible
# - this job is not tested, track it in time and tweak file permissions, etc as needed
(crontab -l 2>/dev/null; echo "0 2 * * * logrotate -f /etc/logrotate.d/eodhd_download # Eodhd download logrotate daily run") | crontab -
# not sure if needed or not, just translating an eodhd_download task to keep compatibility
sudo systemctl restart logrotate
