import signal
import sys
import logging

logger = logging.getLogger(__name__)


def handle_sigterm(signum, frame):
    print("Received SIGTERM, shutting down gracefully...")
    sys.exit(0)


def handle_sigint(signum, frame):
    print("Received SIGINT, shutting down gracefully...")
    sys.exit(0)


def register_signals():
    signal.signal(signal.SIGTERM, handle_sigterm)
    signal.signal(signal.SIGINT, handle_sigint)
