import os
import yaml


def read_yaml_config_with_override(
    main_default_path: str, fallback_default_path: str, user_override_path: str
):
    """
    Docs
    - reads a system default yaml config (from two possible locations, in order or priority)
    - potentially overrides if a user placed yaml config is found at the override path.
    - the merge strategy for override is simple (i.e. non-deep)
    """
    if os.path.exists(main_default_path):
        config_path = main_default_path
    elif fallback_default_path and os.path.exists(fallback_default_path):
        config_path = fallback_default_path
    else:
        raise FileNotFoundError("No valid configuration file found!")

    with open(config_path, "r") as file:
        config = yaml.safe_load(file)

    if user_override_path and os.path.exists(user_override_path):
        with open(user_override_path, "r") as override_file:
            config_override = yaml.safe_load(override_file)
            # Apply a non-deep merge strategy
            config.update(config_override)
    return config
